<p align="center">
    <img src="directory-lister.svg" alt="Directory Lister" width="66%">
</p>

<p align="center">
    <a href="https://github.com/DirectoryLister/DirectoryLister/discussions"><img src="https://img.shields.io/badge/Join_the-Community-7b16ff.svg?style=for-the-badge" alt="Join our Community"></a>
    <a href="https://github.com/users/PHLAK/sponsorship"><img src="https://img.shields.io/badge/Become_a-Sponsor-cc4195.svg?style=for-the-badge" alt="Become a Sponsor"></a>
    <a href="https://paypal.me/ChrisKankiewicz"><img src="https://img.shields.io/badge/Make_a-Donation-006bb6.svg?style=for-the-badge" alt="One-time Donation"></a>
    <br>
    <img alt="Packagist PHP Version Support" src="https://img.shields.io/packagist/php-v/phlak/directory-lister?style=flat-square">
    <a href="https://github.com/DirectoryLister/DirectoryLister/blob/master/LICENSE"><img src="https://img.shields.io/github/license/DirectoryLister/DirectoryLister?style=flat-square" alt="License"></a>
    <a href="https://github.com/DirectoryLister/DirectoryLister/actions" alt="Build Status"><img src="https://img.shields.io/github/actions/workflow/status/DirectoryLister/DirectoryLister/ci-suite.yaml?style=flat-square"></a>
</p>

---

Directory Lister is the easiest way to expose the contents of any web-accessible
folder for browsing and sharing. With a zero configuration, drag-and-drop
installation you'll be up and running in less than a minute.

![Screenshot](screenshot.png)

Directory Lister is created and maintained by
[Chris Kankiewicz](https://www.chriskankiewicz.com)
([@PHLAK.dev](https://bsky.app/profile/phlak.dev)) with help through
[community contributions](https://github.com/DirectoryLister/DirectoryLister/graphs/contributors).

Features
--------

  - **Simple installation** allows you to be up and running in less than a minute.
  - **Light and dark themes** to suit your professional needs or personal style.
  - **Custom sort ordering** gives you control of the ordering of your files/folders.
  - **File search** helps you locate the files you need quickly and efficiently.
  - **File hashes** instill confidence when downloading files through verification.
  - **Readme rendering** allows exposing the contents of READMEs directly on the page.
  - **Zip downloads** for fetching an entire directory of files in a single action.
  - **Multi-lingual support** brings Directory Lister to the language of your choice.

Requirements
------------

  - Directory Lister requires [PHP](https://www.php.net/) >= 8.2
    - The [Zip](https://www.php.net/manual/en/book.zip.php) extension is required for zip downloads
    - The [DOM](https://www.php.net/en/dom) and [Fileinfo](https://www.php.net/manual/en/book.fileinfo.php) extensions are required for README rendering

Installation
------------

### Docker Compose

For quick and easy management via [Docker Compose](https://docs.docker.com/compose/)
check out [Directory Lister Compose](https://github.com/DirectoryLister/directory-lister-compose).

### Manual Installation

  1. [Download Directory Lister](https://www.directorylister.com)
  2. Extract the zip/tar archive
  3. Copy extracted files/folders to your web server

Configuration
-------------

  1. Copy `.env.example` to `.env`
  2. Edit the configuration values in `.env`

See the [Configuration Documentation](https://docs.directorylister.com/configuration) for more information.

Sponsors
--------

Love Directory Lister? [Sponsor development](https://github.com/sponsors/PHLAK)
and have your name or logo featured here!

Changelog
---------

A list of changes can be found on the [GitHub Releases](https://github.com/DirectoryLister/DirectoryLister/releases) page.

Troubleshooting
---------------

See the [Help & Support](https://docs.directorylister.com/help-and-support) section of the documentation for troubleshooting instructions.

For general help and support join our [GitHub Discussion](https://github.com/DirectoryLister/DirectoryLister/discussions) or reach out on [Bluesky](https://bsky.app/profile/directorylister.com).

Please report bugs to the [GitHub Issue Tracker](https://github.com/DirectoryLister/DirectoryLister/issues).

Copyright
---------

This project is licensed under the [MIT License](https://github.com/DirectoryLister/DirectoryLister/blob/master/LICENSE).
